/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.resource;

import java.io.InputStream;
import javax.annotation.Nonnull;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.orecruncher.lib.resource.ResourceAccessorBase;

@OnlyIn(value=Dist.CLIENT)
final class ResourceAccessorPack
extends ResourceAccessorBase {
    private final IResourcePack pack;
    private final ResourceLocation actual;

    public ResourceAccessorPack(@Nonnull ResourceLocation location, @Nonnull IResourcePack pack, @Nonnull ResourceLocation actual) {
        super(location);
        this.pack = pack;
        this.actual = actual;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] getAsset() {
        try (InputStream stream = this.pack.func_195761_a(ResourcePackType.CLIENT_RESOURCES, this.actual);){
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        catch (Throwable t) {
            this.logError(t);
            return null;
        }
    }

    @Override
    public String toString() {
        return String.format("%s (%s = %s)", super.toString(), this.pack.func_195762_a(), this.actual.toString());
    }
}

